<?php
add_filter( 'pre_option_default_category', '__return_empty_string', 999 );
add_filter('manage_post_posts_columns', 'hk_featured_image_column');
function hk_featured_image_column( $column_array ) {
    $column_array = array_slice( $column_array, 0, 1, true )
    + array('featured_image' => 'Ảnh')
    + array_slice( $column_array, 1, NULL, true );
    return $column_array;
}
add_action('manage_posts_custom_column', 'hk_render_the_column', 10, 2);
function hk_render_the_column( $column_name, $post_id ) {
    if( $column_name == 'featured_image' ) {
        if( has_post_thumbnail( $post_id ) ) {          
            $thumb_id = get_post_thumbnail_id( $post_id );
            echo '<img data-id="' . $thumb_id . '" src="' . wp_get_attachment_url( $thumb_id ) . '" />';            
        } else {            
            echo '<img data-id="-1" src="' . get_stylesheet_directory_uri() . '/placeholder.png" />';           
        }       
    }
}
add_action( 'admin_head', 'hk_custom_css' );
function hk_custom_css(){
    echo '<style>#featured_image{width:80px;height:40px}td.featured_image.column-featured_image img{max-width:100%;height:50%;}</style>';
}
add_filter( 'paginate_links', function($link){
if(is_paged()){$link= str_replace('page/1/', '', $link);}
return $link;
} );
// Add custom Theme Functions here
//define('WP_POST_REVISIONS', 0);
define( 'WP_AUTO_UPDATE_CORE', false );
add_filter('pre_site_transient_update_core','remove_core_updates');
add_filter('pre_site_transient_update_plugins','remove_core_updates');
add_filter('pre_site_transient_update_themes','remove_core_updates');

///tắt thông báo cập nhật//////////////////
function remove_core_updates(){
  global $wp_version;
  return(object) array('last_checked'=> time(),'version_checked'=> $wp_version,);
}

function remove_footer_admin () {
echo 'Phát triển bởi Joy.D</p>';
}
add_filter('admin_footer_text', 'remove_footer_admin');
///////////////////////////////////////////////
//Ẩn các panel không cần thiết
add_action('wp_dashboard_setup', 'my_custom_dashboard_widgets');

function my_custom_dashboard_widgets()
{
     global $wp_meta_boxes;
     unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_right_now']);
     unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_recent_comments']);
     unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_incoming_links']);
     unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_plugins']);
     unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_primary']);
     unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_secondary']);
     unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_quick_press']);
     unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_recent_drafts']);
}

//Ẩn Welcome Panel:
add_action( 'load-index.php', 'hide_welcome_panel' );
function hide_welcome_panel() {
    $user_id = get_current_user_id();
    if ( 1 == get_user_meta( $user_id, 'show_welcome_panel', true ) )
        update_user_meta( $user_id, 'show_welcome_panel', 0 );
}

//Xóa logo wordpress
add_action( 'admin_bar_menu', 'remove_wp_logo', 999 );
function remove_wp_logo( $wp_admin_bar ) {
    $wp_admin_bar->remove_node( 'wp-logo' );
}

add_action('wp_footer','devvn_readmore_flatsome');
function devvn_readmore_flatsome(){
    ?>
    <style>
        .taxonomy-description {
            overflow: hidden;
            position: relative;
        }
        .devvn_readmore_flatsome {
            text-align: center;
            cursor: pointer;
            position: absolute;
            z-index: 9999;
            bottom: 0;
            width: 100%;
            background: #ffffffcf;
            padding-bottom: 30px;
        }
        .devvn_readmore_flatsome:before {
            height: 55px;
            margin-top: -45px;
            content: "";
            background: -moz-linear-gradient(top, rgba(255,255,255,0) 0%, #FFF 100%);
            background: -webkit-linear-gradient(top, rgba(255,255,255,0) 0%,#FFF 100%);
            background: linear-gradient(to bottom, rgba(255,255,255,0) 0%,#FFF 100%);
            display: block;
        }
        .devvn_readmore_flatsome span{
            color: #ee8958;
            display: block;
            font-weight: bold;
        }
        .devvn_readmore_flatsome span:after {
            content: '';
            width: 0;
            right: 0;
            border-top: 6px solid #ee8958;
            border-left: 6px solid transparent;
            border-right: 6px solid transparent;
            display: inline-block;
            vertical-align: middle;
            margin: -2px 0 0 5px;
        }
    </style>
    <script>
        window.addEventListener('DOMContentLoaded', (event) => {
        (function($){
            $(document).ready(function(){
                    var hidden_block_view = function(element){
                        var wrap = element;
                        var current_height = wrap.height();
                        var your_height = 250;
                        if(current_height > your_height){
                            wrap.css('height', your_height+'px');
                            wrap.append(function(){
                                return '<div class="devvn_readmore_flatsome"><span title="Xem thêm" href="javascript:void(0);">Xem thêm</span></div>';
                            });
                            $('body').on('click','.devvn_readmore_flatsome', function(){
                                wrap.removeAttr('style');
                                $('body .devvn_readmore_flatsome').remove();
                            });
                        }
                    };
                    
                    if($('.taxonomy-description').length > 0){
                           hidden_block_view($('.taxonomy-description'));                     
                    }
                    
            });
        })(jQuery);
        });
    </script>
    <?php
}

//Bài viết liên quan
function mh_add_post_content($content) {
  if (is_single()) {
    $content .= "<div class='clearfix'></div>";
    global $post;
    $id_post = $post->ID;
    $categories = get_the_category($post->ID);
    if ($categories) {
      $_category_ids = "";
      foreach($categories as $individual_category) $_category_ids = $individual_category->term_id;

      $category_ids = array($_category_ids);
      $args=array(
        'category__in' => $category_ids,
        'post__not_in' => array($post->ID),
        'posts_per_page'=> 8, // Number of related posts that will be shown.
        'caller_get_posts'=>1
      );

      $my_query = new wp_query( $args );
      if( $my_query->have_posts() ) {
        $text_title_related_post_related = 'BÀI ĐĂNG LIÊN QUAN KHÁC';
        $content .= '<div id="related_posts"><div class="title-related-posts"><strong>'. $text_title_related_post_related .'</strong></div><ul>';
        while( $my_query->have_posts() ) {
                $my_query->the_post();
          $content .= '
            <li><a href="'. get_the_permalink().'" title="'.get_the_title().'">'. get_the_title().'</a></li>';
        } //End while
        $content .= "</ul></div> 
        <div class='clearfix'></div>
        <style>
            #related_posts .title-related-posts{padding-bottom:15px;}
            #related_posts ul li{    padding: 5px;    margin: 0px;    border-bottom: 1px dashed #CCC;    list-style: disc;    margin-left: 30px;}
            #related_posts ul li a{text-decoration: none; color: #444; }
            #related_posts ul li a:hover{text-decoration: underline;}
        </style>
        ";
      } //End if
    } //End if

    echo $content;
  }
 
}
add_action ('flatsome_before_comments', 'mh_add_post_content', 100);

function ra_change_translate_text_multiple( $translated ) {
    $text = array(
        'Category Archives:' => "",
        'CATEGORY ARCHIVES:' => '',
        'Tag Archives' => "Thẻ",
        'TAG ARCHIVES' => 'Thẻ',
        'SEARCH RESULTS FOR' => 'Kết quả tìm kiếm'
    );
    $translated = str_ireplace( array_keys($text), $text, $translated );

    return $translated;
}
add_filter( 'gettext', 'ra_change_translate_text_multiple', 20 );


add_filter( 'the_title', 'do_shortcode' );
add_filter( 'wpseo_title', 'do_shortcode' );
add_filter( 'wpseo_metadesc', 'do_shortcode' );
add_shortcode ('hienthinam', 'get_hienthinam');
function get_hienthinam () {$hienthinam= date ("Y"); return "$hienthinam"; }
add_shortcode ('hienthithang', 'get_hienthithang');
function get_hienthithang () {$hienthithang= date ("m"); return "$hienthithang"; }
add_shortcode ('hienthingay', 'get_hienthingay');
function get_hienthingay () {$hienthingay= date ("d"); return "$hienthingay"; }


// remove wp version number from scripts and styles
function remove_css_js_version( $src ) {
    if( strpos( $src, '?ver=' ) )
        $src = remove_query_arg( 'ver', $src );
    return $src;
}
add_filter( 'style_loader_src', 'remove_css_js_version', 9999 );
add_filter( 'script_loader_src', 'remove_css_js_version', 9999 );

// remove wp version number from head and rss
function artisansweb_remove_version() {
    return '';
}
add_filter('the_generator', 'artisansweb_remove_version');

function add_breadcrum_rankmath(){
    
    //add breadcrumbs Breadcrumb NavXT Plugin
    if(function_exists('rank_math_the_breadcrumbs')){
        if( ! is_home() && ! is_front_page() ){
            $class = " padding-bottom-col";
            echo '<div class="breadcrumbs-div '.$class.'"><div class="row"><div class="col large-12"><div class="breadcrumbs">';
            rank_math_the_breadcrumbs();
            echo '</div></div></div></div>';
        }
    }
}
add_action("flatsome_before_content_joy", "add_breadcrum_rankmath");

function add_more_description_author_page(){
    if(is_author()){
        $author_id = get_the_author_meta('ID');
        $info_descriptions = get_field('info_descriptions', 'user_'. $author_id );
        if($info_descriptions){
        ?>
        <div class="row"><div class="col large-12">
            <div class="taxonomy-description">
                <?php echo apply_filters('richedit_pre', $info_descriptions); ?>
            </div>
            </div></div>
        <?php
        }
    }
}
add_action('flatsome_before_blog', 'add_more_description_author_page', 100);

function defer_parsing_of_js ( $url ) {
    if ( FALSE === strpos( $url, '.js' ) || strpos( $url, 'jquery.js' ) || strpos( $url, 'jquery.min.js' ) || strpos( $url, '\/gtag\/' ) || is_user_logged_in() ) return $url;
    return "$url' defer='defer";
}

if ( ! function_exists( 'flatsome_posted_on' ) ) :
function flatsome_posted_on() {
    ?>
    <span class="posted-on"><i class="far fa-clock"></i> Ngày viết <a href="#" rel="bookmark"><time class="entry-date published updated" datetime="<?php echo date(DATE_ISO8601, strtotime(get_the_date('Y-m-d H:i:s')));?>"><?php echo get_the_date('d/m/Y')?></time></a></span>
    <span class="byline"><i class="far fa-user"></i>  bởi <a href="<?php echo(get_author_posts_url(get_the_author_meta('ID')))?>"><?php echo esc_html(get_the_author())?></a></span>
    <?php
}
endif;

add_filter('comment_form_default_fields', 'unset_url_field');
function unset_url_field($fields){
    if(isset($fields['url']))
       unset($fields['url']);
       return $fields;
}




